# Proto 1 PMT Channel 1 Test
# 2020-09-09/Struebing, Leuschner
#
import asyncio
from py_pli.pylib import VUnits
from virtualunits.vu_measurement_unit import VUMeasurementUnit
from virtualunits.vu_node_application import VUNodeApplication
import time as t
from datetime import datetime as DT



# Initialization #######################################################################################################

async def init():
    await VUnits.instance.hal.nodes["EEFNode"].StartFirmware()
    
    print(f"eef initialized")

# Sequencer ############################################################################################################

signals = {
    'flash'     : (1 << 23),
    'alpha'     : (1 << 22),
    'ingate2'   : (1 << 17),
    'ingate1'   : (1 << 16),
    'hvgate2'   : (1 << 13),
    'hvgate1'   : (1 << 12),
    'hvon3'     : (1 << 10),
    'hvon2'     : (1 <<  9),
    'hvon1'     : (1 <<  8),
    'rstaux'    : (1 <<  6),
    'rstabs'    : (1 <<  5),
    'rstref'    : (1 <<  4),
    'rstpmt2'   : (1 <<  1),
    'rstpmt1'   : (1 <<  0),
}


triggers = {
    'trf'   : (1 << 8),
    'aux'   : (1 << 6),
    'abs'   : (1 << 5),
    'ref'   : (1 << 4),
    'pmt3'  : (1 << 2),
    'pmt2'  : (1 << 1),
    'pmt1'  : (1 << 0),
}

async def get_results(address, size):
    meas = VUnits.instance.hal.measurementUnit.MeasurementFunctions
    #meas = get_measurement_endpoint()
    return (await meas.ReadResults(address, size, timeout=5))[:size]


async def write_sequence(address, sequence):
    if len(sequence) > 28:
        raise Exception(f"Maximum sequence length of 28 instructions exceeded.")
    
    meas = VUnits.instance.hal.measurementUnit.MeasurementFunctions

    buffer = [0] * 28
    for i in range(len(sequence)):
        buffer[i] = sequence[i]

    await meas.WriteSequence(address, len(sequence), buffer, timeout=5)


async def start_sequence(address, poll_interval=0.1):
    meas = VUnits.instance.hal.measurementUnit.MeasurementFunctions
    
    await meas.StartSequence(address, timeout=1)

    status = 0
    while (status & 0x01) == 0:
        await asyncio.sleep(poll_interval)
        status = (await meas.GetStatus(timeout=1))[0]
    print(f"Sequence finished")


async def hvpmt1on():
    address = 0
    sequence = [
            0x02000000 | signals['hvon1'],
            0x00000000,
        ]
    await write_sequence(address, sequence)
    await start_sequence(address)
    print('=============HV PMT1 On!!!==================')

async def hvpmt1off():
    address = 0
    sequence = [
            0x03000000 | signals['hvon1'],
            0x00000000,
        ]
    await write_sequence(address, sequence)
    await start_sequence(address)
    print('=============HV PMT1 Off!!!==================')

async def hvgate(enable):
    address = 0
    if enable:
        sequence = [
            0x02000000 | signals['hvgate1'],
            0x00000000,
        ]
    else:
        sequence = [
            0x03000000 | signals['hvgate1'],
            0x00000000,
        ]
    await write_sequence(address, sequence)
    await start_sequence(address)

async def darkcount(iterations, cnt_window=1000, pre_cnt_window=100000):
    address = 0
    sequence = [
        0x7C000000 | (pre_cnt_window - 1),  # TimerWaitAndRestart(pre_cnt_window - 1)
        0x88B80000,                         # PulseCounterControl(ch=0, add=0, RstCnt=1, RstPreCnt=1, corr=1)
        0x07000000 | (cnt_window - 1),      # Loop(cnt_window - 1)
        0x7C000000 | (pre_cnt_window - 1),  #     TimerWaitAndRestart(pre_cnt_window - 1)
        0x88D00000,                         #     PulseCounterControl(ch=0, add=1, RstCnt=0, RstPreCnt=1, corr=0)
        0x05000000,                         # LoopEnd()
        0x80900000,                         # GetPulseCounterResult(ch=0, rel=0, RstCnt=1, add=0, dword=0, addrReg=0, addr=0)
        0x00000000,                         # Stop(0)
    ]
    await init()
#    await hvpmt1on()
    await hvgate(enable=True)
    await write_sequence(address, sequence)
    with open('darkcount_test_2020-09-28.txt', mode='a') as file:
        window_ms = 0.00001 * cnt_window * pre_cnt_window
        time_stamp = DT.now().strftime('%Y-%m-%d_%H-%M')
        file.write(f"Darkcount PMT 1, {time_stamp} \n")
        file.write(f"index;count (window = {window_ms} ms)\n")
        for i in range(iterations):
            try:
                await start_sequence(address, poll_interval=1)
                results = await get_results(address=0, size=1)
                print(f"{i+1}, {results[0]}")
                file.write(f"{i+1}, {results[0]}\n")
            except BaseException as ex:
                print(f"darkcount() failed: {ex}")
                file.write(f"darkcount() failed: {ex}\n")
    await hvgate(enable=False)
#    await hvpmt1off()

